/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectVersionFormatException;
import oracle.sysman.oip.oipc.oipch.OipchVersion;

public class OipchAIXVersion
extends OipchVersion {
    private long m_lMajor;
    private long m_lMinor;
    private String m_sVersion;
    static final String VERSION_SEPARATOR_STR = ".";
    static final char VERSION_SEPARATOR = '.';
    static final String defaultMinorNum = "00";

    public OipchAIXVersion(String ver) {
        super(ver, ver);
        try {
            this.setAIXVersion(ver);
        }
        catch (OipchIncorrectVersionFormatException e) {
            e.printStackTrace();
        }
    }

    private void setAIXVersion(String ver) throws OipchIncorrectVersionFormatException {
        int idx;
        if (ver == null) {
            throw new OipchIncorrectVersionFormatException("OUI-11037", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11037"));
        }
        if (!(ver = ver.trim()).contains(VERSION_SEPARATOR_STR)) {
            ver = ver.concat(VERSION_SEPARATOR_STR);
            ver = ver.concat(defaultMinorNum);
        }
        if ((idx = ver.indexOf(46)) == -1) {
            Object[] args = new String[]{ver};
            throw new OipchIncorrectVersionFormatException("OUI-11036", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11036", (Object[])args));
        }
        String sMajor = ver.substring(0, idx);
        String sMinor = ver.substring(idx + 1);
        try {
            this.m_lMajor = Long.parseLong(sMajor);
            this.m_lMinor = Long.parseLong(sMinor);
            this.m_sVersion = ver;
        }
        catch (NumberFormatException e) {
            Object[] args = new String[]{ver, e.getMessage()};
            throw new OipchIncorrectVersionFormatException("OUI-11038", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11038", (Object[])args), e);
        }
    }

    public int compare(Object other) {
        int iResult = 8;
        if (other != null) {
            if (other == this) {
                iResult = 1;
            } else if (other instanceof OipchAIXVersion) {
                OipchAIXVersion v2 = (OipchAIXVersion)other;
                iResult = this.m_lMajor == v2.getMajorVersion() ? (this.m_lMinor == v2.getMinorVersion() ? 1 : (this.m_lMinor < v2.getMinorVersion() ? 2 : 1)) : (this.m_lMajor < v2.getMajorVersion() ? 2 : 4);
            }
        }
        return iResult;
    }

    private long getMajorVersion() {
        return this.m_lMajor;
    }

    private long getMinorVersion() {
        return this.m_lMinor;
    }

    public boolean isCompatible(Object obj) {
        int iCompare = this.compare(obj);
        return iCompare == 1 || iCompare == 4;
    }

    public String getVersion() {
        return this.m_sVersion;
    }
}

